#include <Windows.h>
#include <stdio.h>
#include "controller.h"

#define NumberOfButtons 7

BUTTONS Controller1;

struct {
	DWORD vkey;
	DWORD button;
} Keys[NumberOfButtons];

EXPORT void CALL CloseDLL (void) {
}

EXPORT void CALL ControllerCommand ( int Control, BYTE * Command) {
}

EXPORT void CALL DllAbout ( HWND hParent ) {
	MessageBox(hParent,"Basic Keyboard plugin\nBy Zilmar","Dll About",MB_OK);
}

EXPORT void CALL DllConfig ( HWND hParent ) {
	MessageBox(hParent,"Start:\tEnter\nA:\tZ\nB:\tX\nD-Pad:\tarrows\na-stick:\tarrows",
		"Controller Keys",MB_OK);
}

EXPORT void CALL GetDllInfo ( PLUGIN_INFO * PluginInfo ) {
	PluginInfo->Version = 0x0100;
	PluginInfo->Type = PLUGIN_TYPE_CONTROLLER;
	sprintf(PluginInfo->Name,"Basic KeyBoard plugin");
}

EXPORT void CALL GetKeys(int Control, BUTTONS * Keys ) {
	if (Keys == NULL) { return; }
	Keys->Value = Controller1.Value;
}

EXPORT void CALL InitiateControllers (HWND hMainWindow, CONTROL Controls[4]) {
	BUTTONS Buttons;

	Controls[0].Present = TRUE;
	Controls[0].RawData = FALSE;
	Controls[0].Plugin  = PLUGIN_NONE;
	Controls[1].Present = FALSE;
	Controls[2].Present = FALSE;
	Controls[3].Present = FALSE;

	Buttons.Value  = 0;					//Up
	Buttons.X_AXIS = 80;
	Buttons.U_DPAD = 1;
	Keys[0].vkey   = VK_UP;
	Keys[0].button = Buttons.Value;

	Buttons.Value  = 0;					//Down
	Buttons.X_AXIS = -80;
	Buttons.D_DPAD = 1;
	Keys[1].vkey   = VK_DOWN;
	Keys[1].button = Buttons.Value;

	Buttons.Value  = 0;					//left
	Buttons.Y_AXIS = -80;
	Buttons.L_DPAD = 1;
	Keys[2].vkey   = VK_LEFT;
	Keys[2].button = Buttons.Value;

	Buttons.Value  = 0;					//Right
	Buttons.Y_AXIS = 80;
	Buttons.R_DPAD = 1;
	Keys[3].vkey   = VK_RIGHT;
	Keys[3].button = Buttons.Value;

	Buttons.Value  = 0;					//Start button
	Buttons.START_BUTTON = 1;
	Keys[4].vkey   = VK_RETURN;
	Keys[4].button = Buttons.Value;

	Buttons.Value  = 0;					//A button
	Buttons.A_BUTTON = 1;
	Keys[5].vkey   = 'Z';
	Keys[5].button = Buttons.Value;

	Buttons.Value  = 0;					//B button
	Buttons.B_BUTTON = 1;
	Keys[6].vkey   = 'X';
	Keys[6].button = Buttons.Value;
}

EXPORT void CALL ReadController ( int Control, BYTE * Command ) {
}

EXPORT void CALL RomClosed (void) {
}

EXPORT void CALL RomOpen (void) {
}

EXPORT void CALL WM_KeyDown( WPARAM wParam, LPARAM lParam ) {
	int count;
	for (count = 0; count < NumberOfButtons; count++) {
		if (Keys[count].vkey == wParam) { 
			Controller1.Value |= Keys[count].button; 
			return;
		}
	}
}

EXPORT void CALL WM_KeyUp( WPARAM wParam, LPARAM lParam ) {
	int count;

	for (count = 0; count < NumberOfButtons; count++) {
		if (Keys[count].vkey == wParam) { 
			Controller1.Value &= ~Keys[count].button; 
			return;
		}
	}
}








